clc; clear; 

%% Problem Data

rng(1)

n = 4; %number of variables
Q = randn(n); 
Q = .5*(Q'*Q); % make it P.D.
h  = randn(n,1);

x0 = randn(n,1);


m = 8; %number of constraints
A = randn(m,n);
b = randn(m,1);
  




%% Algorithm

options = optimoptions('quadprog','Algorithm','active-set','OptimalityTolerance',1e-8,'Display','off');
[x_qp,f_qp] = quadprog(Q,h,A,b,[],[],[],[],x0,options);


% Projected grad descent
[x_pgd,data,k] = Projected_Grad_Desc(@(x)(objective(x,Q,h)),Q,h,A,b,x0);

fprintf('Solution found by PGD\n')
disp(x_pgd)
fprintf('Function value %.4e \n',0.5*x_pgd'*Q*x_pgd + h'*x_pgd)


%% Plotting

% solve the GAP problem
options = optimoptions('linprog','OptimalityTolerance',1e-8,'Display','off');

GAP = ones(k,1);
for i = 1:k
    
    [~,f_star] = linprog(data.g(:,i),A,b,[],[],[],[],options);
    GAP(i)=-(f_star-data.g(:,i)'*data.x(:,i));

end

figure(1)
plot(data.f,'LineWidth',2,'Color','b')
xlabel('Iterations')
ylabel('f(xk)')
title("Objective function")

figure(2)
plot(GAP,'LineWidth',2,'Color','b')
xlabel('Iterations')
ylabel('GAP(xk)')
title("GAP function")

fprintf('Final GAP value %.4e \n',GAP(end));

figure(3)
semilogy(GAP,'LineWidth',2,'Color','b')
xlabel('Iterations')
ylabel('GAP(xk)')
title("GAP function semilog")








